#include <passport/infra/daemons/logstoreagent/src/utils/lock_file.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NLogstoreAgent;

Y_UNIT_TEST_SUITE(LockFile) {
    Y_UNIT_TEST(invalidArg) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TLockFile("asdf"),
                                       yexception,
                                       "Path must exist:");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TLockFile("/dev/null"),
                                       yexception,
                                       "Path must be directory");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TLockFile("/"),
                                       yexception,
                                       "/lock");
    }

    Y_UNIT_TEST(common) {
        const TString filename = "./lock";
        NFs::Remove(filename);

        UNIT_ASSERT_NO_EXCEPTION(TLockFile("./"));
        UNIT_ASSERT(NFs::Exists(filename));

        TLockFile lock("./");
        UNIT_ASSERT_EXCEPTION_CONTAINS(TLockFile("./"),
                                       yexception,
                                       "flock");
    }
}
