#include <passport/infra/daemons/logstoreagent/src/utils/state_holder.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/fs.h>

using namespace NPassport;
using namespace NPassport::NLogstoreAgent;

Y_UNIT_TEST_SUITE(StateHolder) {
    class TTestHolder: public TDiskStateHolder {
    public:
        using TDiskStateHolder::Parse;
        using TDiskStateHolder::Serialize;
        using TDiskStateHolder::TDiskStateHolder;
    };

    Y_UNIT_TEST(serialize) {
        UNIT_ASSERT_VALUES_EQUAL(
            "0100000000000000000000000000000000",
            NUtils::Bin2hex(TTestHolder::Serialize(TDiskStateHolder::TState{})));
        UNIT_ASSERT_VALUES_EQUAL(
            "01000000000098aa08000000000000002a",
            NUtils::Bin2hex(TTestHolder::Serialize(TDiskStateHolder::TState{
                .Offset = 10005000,
                .Inode = 42,
            })));
    }

    Y_UNIT_TEST(parse) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TTestHolder::Parse(""),
            yexception,
            "There is no state");
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TTestHolder::Parse(NUtils::Hex2bin("030000")),
            yexception,
            "version is not supported: 3");
        UNIT_ASSERT_EXCEPTION_CONTAINS(
            TTestHolder::Parse(NUtils::Hex2bin("010000")),
            yexception,
            "bad body size: expected 17, got 3");

        UNIT_ASSERT_VALUES_EQUAL(
            TDiskStateHolder::TState({
                .Offset = 10005000,
                .Inode = 42,
            }),
            TTestHolder::Parse(NUtils::Hex2bin("01000000000098aa08000000000000002a")));
    }

    Y_UNIT_TEST(common) {
        const TString filename = "./state";
        NFs::Remove(filename);

        const TDiskStateHolder::TState someState{
            .Offset = 10005000,
            .Inode = 42,
        };

        {
            TTestHolder h("./");
            UNIT_ASSERT(NFs::Exists(filename));
            UNIT_ASSERT(!h.Read());
        }

        {
            TTestHolder h("./");
            UNIT_ASSERT(!h.Read());

            const TDiskStateHolder::TState someOtherState{
                .Offset = 50001000,
                .Inode = 715,
            };

            h.Write(someOtherState);
            UNIT_ASSERT_VALUES_EQUAL(someOtherState, h.Read());
            UNIT_ASSERT_VALUES_EQUAL(someOtherState, h.Read());

            h.Write(someState);
            UNIT_ASSERT_VALUES_EQUAL(someState, h.Read());
            UNIT_ASSERT_VALUES_EQUAL(someState, h.Read());
        }

        {
            TTestHolder h("./");
            UNIT_ASSERT_VALUES_EQUAL(someState, h.Read());
        }
    }
}

template <>
void Out<IStateHolder::TState>(IOutputStream& out, const IStateHolder::TState& value) {
    out << "offset: " << value.Offset << Endl;
    out << "inode: " << value.Inode << Endl;
}

template <>
void Out<std::optional<IStateHolder::TState>>(IOutputStream& out,
                                              const std::optional<IStateHolder::TState>& value) {
    if (value) {
        out << *value;
    } else {
        out << "NULL";
    }
}
