import json
import sys


SETTINGS = {
    "development": {
        "SELF_TVM_ID": 2028824,
        "ALLOWED_TVMIDS": [
            2030187,  ## logstore-agent-dev
        ],
        "ENVS": [
            "development",
        ],
    },
    "production": {
        "SELF_TVM_ID": 2028826,
        "ALLOWED_TVMIDS": [
            2030195,  # logstore-agent-production
            2030189,  # logstore-agent-testing
            2030197,  # logstore-agent-rc
            2030193,  # logstore-agent-yateam
            2030199,  # logstore-agent-yateam-rc
            2030191,  # logstore-agent-yateam-testing
        ],
        "ENVS": [
            "production",
            "production-intranet",
            "production-other",
            "rc",
            "rc-intranet",
            "testing",
            "testing-beta",
            "testing-intranet",
        ],
    },
}


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, json.dumps(value))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
