import json
import sys


SETTINGS = {
    "logstore-f1.passport.yandex.net": {
        "HOST": 'logstore-f1.passport.yandex.net',
        "IP": '2a02:6b8:c01:72c:8000:611:0:4',
    },
    "kvs-logstore-f1.passport.yandex.net": {
        "HOST": 'kvs-logstore-f1.passport.yandex.net',
        "IP": '2a02:6b8:c01:72c:8000:635:0:5',
    },
    "mon-logstore-f1.passport.yandex.net": {
        "HOST": 'mon-logstore-f1.passport.yandex.net',
        "IP": '2a02:6b8:c01:72c:8000:635:0:6',
    },
    "logstore-s1.passport.yandex.net": {
        "HOST": 'logstore-s1.passport.yandex.net',
        "IP": '2a02:6b8:c02:f1d:8000:611:0:11',
    },
}


def do(template, env, host):
    if env != 'production':
        return

    if host not in SETTINGS:
        raise Exception("host '%s' is unknown" % host)

    setts = SETTINGS[host]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, str(value))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 4:
        print("Usage: %s <template_file> <env> <host>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2], sys.argv[3])
