#pragma once

#include <library/cpp/threading/future/future.h>

#include <util/datetime/base.h>
#include <util/generic/fwd.h>
#include <util/generic/string.h>
#include <util/string/builder.h>

#include <condition_variable>
#include <mutex>
#include <thread>
#include <vector>

namespace NPassport {
    class TLoggingStream;
}

namespace NPassport::NLogstoreApi {
    class TLogger {
    public:
        struct TBuffer {
            TString Data;
            NThreading::TPromise<void> Promise;
        };

    public:
        TLogger(const TString& filename, const int linesPerShot = 1024);

        ~TLogger();

        NThreading::TFuture<void> Log(TString&& str) const;

        void Rotate();

    private:
        bool OpenFile();

        NThreading::TFuture<void> AddToQueue(TString&& str) const;

        void WritingThread(const size_t linesPerShot);

    private:
        // File name
        const TString Filename_;

        const TString Pid_;

        // File descriptor
        int Fd_ = -1;
        std::atomic_bool NeedReopen_;

        // Writing queue.
        // All writes happens in separate thread. All someInternal methods just
        // push string into queue and signal conditional variable.

        // Logger is stopping.
        std::atomic<bool> Stopping_;

        // Writing queue.
        mutable std::vector<TBuffer> Queue_;

        // Condition and mutex for signalling.
        mutable std::condition_variable QueueCondition_;
        mutable std::mutex QueueMutex_;

        mutable TInstant LastNotify_;

        // Writing thread.
        std::thread WritingThread_;
    };
}
