#pragma once

#include "processor.h"

#include <passport/infra/libs/cpp/request/request.h>

#include <unordered_set>

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NTvmAuth {
    class TTvmClient;
}

namespace NPassport::NLogstoreApi {
    class TChunk;
    class TSimpleWriter;

    class TLogstoreApi {
    public:
        TLogstoreApi();
        ~TLogstoreApi();

        void Init(const NJson::TConfig& config);

        void HandleRequest(NCommon::TRequest& req);

        void AddUnistat(NUnistat::TBuilder& builder);
        void AddUnistatExtended(const TString& path, NUnistat::TBuilder& builder);

    private:
        void InitTvm(const NJson::TConfig& config, const TString& jpoint);

        void HandleRequestImpl(NCommon::TRequest& req);

        NJuggler::TStatus GetStatus() const;
        void CheckAuth(const NCommon::TRequest& req);

    private:
        std::unique_ptr<TProcessor> Processor_;

        std::unique_ptr<NTvmAuth::TTvmClient> Tvm_;
        std::unordered_set<ui32> AllowedTvmIds_;
        ui32 SelfTvmId_ = 0;
    };
}
