#include "plain_text_parser.h"

#include <passport/infra/daemons/logstoreapi/src/utils/exceptions.h>

namespace NPassport::NLogstoreApi {
    TPlainTextParser::TPlainTextParser(size_t offset)
        : Offset_(offset)
    {
    }

    std::vector<TLogLine> TPlainTextParser::Parse(const TStringBuf data) const {
        std::vector<TLogLine> logs;
        TStringBuf buffer(data);

        if (!buffer.EndsWith('\n')) {
            throw TBadRequestError() << "Chunk must end with endline";
        }

        while (buffer) {
            size_t pos = buffer.find('\n') + 1;
            logs.push_back(TLogLine{
                // TODO: get rid of double copy
                .Line = TString(buffer.SubStr(0, pos)),
                .Offset = Offset_ + (data.size() - buffer.size()),
            });
            buffer = buffer.SubStr(pos);
        }

        return logs;
    }
}
