#pragma once

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/unistat/diff.h>

#include <library/cpp/http/misc/httpcodes.h>

#include <util/datetime/base.h>

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLogstoreApi {
    class TChunk;
    class TLogAggregator;
    struct TPushRequest;
    class TSimpleWriter;

    struct TProcessorSettings {
        TDuration RequestTimeout = TDuration::MilliSeconds(500);
    };

    class TProcessor {
    public:
        TProcessor(std::unique_ptr<TLogAggregator> logAggregator, const TProcessorSettings& settings);
        ~TProcessor();

        void Process(const NCommon::TRequest& req);

        void CreateSession(const NCommon::TRequest& req);

        static std::unique_ptr<TProcessor> Create(const NJson::TConfig& config, const TString& point);

        void AddUnistat(NUnistat::TBuilder& builder);
        void AddUnistatForLogs(NUnistat::TBuilder& builder);

    private:
        NUnistat::TSignalDiff<ui64> SignalCompressedLogs_ = {"processor.compressed_bytes"};
        NUnistat::TSignalDiff<ui64> SignalRawLogs_ = {"processor.raw_bytes"};
        static std::unique_ptr<TChunk> Parse(const TPushRequest& requestData);

        std::unique_ptr<TLogAggregator> Aggregator_;

        const TProcessorSettings Settings_;
    };
}
