#include "data_types.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NLogstoreApi {
    TString TStreamInfo::LogableId() const {
        return NUtils::CreateStr("[", Env, ":", Host, ":", File, "]");
    }
}

using namespace NPassport::NLogstoreApi;

template <>
bool TryFromString<ETimeAggregation>(const TString& s, ETimeAggregation& result) {
    if (s == "day") {
        result = ETimeAggregation::Day;
    } else if (s == "hour") {
        result = ETimeAggregation::Hour;
    } else {
        return false;
    }
    return true;
}
