#pragma once

#include <passport/infra/libs/cpp/json/writer.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <util/generic/yexception.h>

static const TString PREFIX_LOGSTOREAPI = "LogstoreApi: ";
static const TString PREFIX_BAD_REQUEST = "Bad Request: ";
static const TString PREFIX_AUTHORIZATION = "Authorization Error: ";
static const TString PREFIX_PARSE_ERROR = "Parse Error: ";
static const TString PREFIX_TIMEOUT = "Timeout: ";
static const TString PREFIX_BUFFER_OVERFLOW = "Buffer Overflow: ";
static const TString PREFIX_INVALID_PATH = "Invalid path: ";
static const TString PREFIX_DUPLICATE = "Duplicate chunk: ";
static const TString PREFIX_MISSING_DATA = "Missing data: ";

namespace NPassport::NLogstoreApi {
    class TLogstoreApiError: public yexception {
    public:
        TString Message() const {
            return NUtils::CreateStr(Prefix(), what());
        }

        virtual void AddFields(NJson::TObject&) const {
        }

    protected:
        virtual const TString& Prefix() const {
            return PREFIX_LOGSTOREAPI;
        }
    };

    class TBadRequestError: public TLogstoreApiError {
    private:
        const TString& Prefix() const final {
            return PREFIX_BAD_REQUEST;
        }
    };

    class TAuthError: public TLogstoreApiError {
    private:
        const TString& Prefix() const final {
            return PREFIX_AUTHORIZATION;
        }
    };

    class TTimeoutError: public TLogstoreApiError {
    private:
        const TString& Prefix() const final {
            return PREFIX_TIMEOUT;
        }
    };

    class TBufferOverflowError: public TLogstoreApiError {
    private:
        const TString& Prefix() const final {
            return PREFIX_BUFFER_OVERFLOW;
        }
    };

    class TInvalidPathError: public TLogstoreApiError {
    private:
        const TString& Prefix() const final {
            return PREFIX_INVALID_PATH;
        }
    };

    class TErrorWithOffset: public TLogstoreApiError {
    public:
        explicit TErrorWithOffset(ui64 offset)
            : Offset_(offset)
        {
        }

        void AddFields(NJson::TObject& root) const override {
            root.Add("offset", Offset_);
        }

    private:
        const ui64 Offset_;
    };

    class TDuplicateError: public TErrorWithOffset {
    public:
        explicit TDuplicateError(ui64 offset)
            : TErrorWithOffset(offset)
        {
        }

    private:
        const TString& Prefix() const final {
            return PREFIX_DUPLICATE;
        }
    };

    class TMissingDataError: public TErrorWithOffset {
    public:
        explicit TMissingDataError(ui64 offset)
            : TErrorWithOffset(offset)
        {
        }

    private:
        const TString& Prefix() const final {
            return PREFIX_MISSING_DATA;
        }
    };
}
