#include "extractor.h"

#include <library/cpp/streams/zstd/zstd.h>

#include <util/stream/str.h>
#include <util/stream/zlib.h>

namespace NPassport::NLogstoreApi {
    TCompressionProcessor::TCompressionProcessor(ECompressionCodec codec)
        : Codec_(codec)
    {
    }

    TString TCompressionProcessor::Extract(const TString& data) const {
        TStringInput input(data);
        std::unique_ptr<IInputStream> coder;

        switch (Codec_) {
            case ECompressionCodec::GZip:
                coder = std::make_unique<TZLibDecompress>(&input);
                break;
            case ECompressionCodec::ZStd:
                coder = std::make_unique<TZstdDecompress>(&input);
                break;
            case ECompressionCodec::PlainText:
                return data;
                break;
        }

        return coder->ReadAll();
    }
}
