#pragma once

#include <passport/infra/daemons/logstoreapi/src/utils/data_types.h>

#include <library/cpp/threading/future/future.h>

#include <memory>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLogstoreApi {
    class IWriter {
    public:
        virtual ~IWriter() = default;

        virtual NThreading::TFuture<void> Write(const TChunk&) = 0;

        virtual void AddUnistat(NUnistat::TBuilder& builder) = 0;
    };

    using TWriterPtr = std::shared_ptr<IWriter>;

    class IWriterFactory {
    public:
        virtual ~IWriterFactory() = default;

        virtual TWriterPtr CreateWriter(const TString& filename) const = 0;
    };

    using TWriterFactoryPtr = std::shared_ptr<IWriterFactory>;
}
