#pragma once

#include "sequencer.h"

#include <library/cpp/threading/future/future.h>

#include <util/folder/path.h>
#include <util/generic/hash.h>

#include <shared_mutex>

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLogstoreApi {
    class TLogsManager;
    class TChunk;
    class TSequencer;
    class IWriter;
    struct TStreamRequest;

    struct TLogAggregatorSettings {
        TFsPath Path;
        size_t BufferLimit = 4096;
        size_t MemoryLimit = 1 << 15;
    };

    // TODO: this is an awkward structure, consider using a TStreamId as a key
    struct TStream: TMoveOnly {
        template <typename... Args>
        explicit TStream(Args&&... args)
            : Sequencer(std::forward<Args>(args)...)
        {
        }

        TSequencer Sequencer;
        TInstant Timestamp;
        TString StreamId;
        ETimeAggregation Aggregation = ETimeAggregation::Day;
    };

    class TLogAggregator {
    public:
        explicit TLogAggregator(std::unique_ptr<TLogsManager> logsManager,
                                TLogAggregatorSettings&& settings);
        ~TLogAggregator();

        NThreading::TFuture<void> Aggregate(std::unique_ptr<TChunk> chunk);

        void AddStream(const TStreamRequest& request);

        static std::unique_ptr<TLogAggregator> Create(const NJson::TConfig& config, const TString& point);

        void AddUnistat(NUnistat::TBuilder& builder);
        void AddUnistatForLogs(NUnistat::TBuilder& builder);

    private:
        struct TPerFile {
            THashMap<TString, std::shared_ptr<TStream>> StreamByHost;
            TSequencerUnistatPtr Unistat;
        };

    private:
        std::shared_ptr<TStream> GetStream(TStringBuf host, TStringBuf file);

    private:
        const TLogAggregatorSettings Settings_;
        std::unique_ptr<TLogsManager> LogsManager_;
        std::shared_ptr<NLb::TResourceDispatcher> ResourceDispatcher_;

        THashMap<TString, TPerFile> Queue_;

        mutable std::shared_mutex StreamLock_;
    };
}
