#include "simple_writer.h"

#include <passport/infra/libs/cpp/unistat/builder.h>
#include <passport/infra/libs/cpp/unistat/name_factory.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NLogstoreApi {
    static const TString PREFIX_SEPARATOR = ": ";

    TSimpleWriter::TSimpleWriter(const TString& filename)
        : Filename_(filename)
    {
        Logger_ = std::make_unique<TLogger>(filename);

        InitUnistat();
    }

    TSimpleWriter::~TSimpleWriter() = default;

    NThreading::TFuture<void> TSimpleWriter::Write(const TChunk& chunk) {
        std::vector<NThreading::TFuture<void>> futures;
        futures.reserve(chunk.Lines().size() + 1);
        if (chunk.Error()) {
            futures.push_back(Logger_->Log(NUtils::CreateStr(chunk.Host(), PREFIX_SEPARATOR, "<<ERROR: ", *chunk.Error(), ">>")));
        }
        for (const TLogLine& logLine : chunk.Lines()) {
            futures.push_back(Logger_->Log(NUtils::CreateStr(chunk.Host(), PREFIX_SEPARATOR, logLine.Line)));
        }
        *SignalTotal_ += chunk.size();

        return NThreading::WaitExceptionOrAll(futures);
    }

    void TSimpleWriter::AddUnistat(NUnistat::TBuilder& builder) {
        builder.Add(*SignalTotal_);
    }

    TWriterPtr TSimpleWriterFactory::CreateWriter(const TString& filename) const {
        return std::make_shared<TSimpleWriter>(filename);
    }

    void TSimpleWriter::InitUnistat() {
        NUnistat::TNameFactory helper("writer", {{"dst_file", Filename_}});
        SignalTotal_ = std::make_unique<NUnistat::TSignalDiff<ui64>>(helper.Name("total_bytes"));
    }
}
