#pragma once

#include "base_writer.h"

#include <passport/infra/daemons/logstoreapi/src/logger/logger.h>

#include <passport/infra/libs/cpp/unistat/diff.h>

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NLogstoreApi {
    class TSimpleWriter: public IWriter {
    public:
        explicit TSimpleWriter(const TString& filename);
        ~TSimpleWriter() override;

        NThreading::TFuture<void> Write(const TChunk& chunk) override;

        void AddUnistat(NUnistat::TBuilder& builder) override;

    private:
        void InitUnistat();

    private:
        std::unique_ptr<TLogger> Logger_;

        std::unique_ptr<NUnistat::TSignalDiff<ui64>> SignalTotal_;

        TString Filename_;
    };

    class TSimpleWriterFactory: public IWriterFactory {
    public:
        TWriterPtr CreateWriter(const TString& filename) const override;
    };
}
