#include "time_aggregator.h"

#include <util/draft/date.h>
#include <util/draft/datetime.h>

namespace NPassport::NLogstoreApi {
    TTimeAggregatorPtr ITimeAggregator::Create(ETimeAggregation type) {
        switch (type) {
            case ETimeAggregation::Day:
                return std::make_unique<TDayAggregator>();
            case ETimeAggregation::Hour:
                return std::make_unique<THourAggregator>();
        }
    }

    TString TDayAggregator::GetSuffix(TInstant ins) const {
        return ins.FormatLocalTime("%Y%m%d");
    }

    TInstant TDayAggregator::GetDeadline(TInstant ins) const {
        TDate date(ins.Seconds());

        return TInstant::Seconds((++date).GetStart());
    }

    TString THourAggregator::GetSuffix(TInstant ins) const {
        return ins.FormatLocalTime("%Y%m%d%H");
    }

    TInstant THourAggregator::GetDeadline(TInstant ins) const {
        TDate date(ins.Seconds());
        ui32 hours = NDatetime::TSimpleTM::NewLocal(ins.Seconds()).Hour;

        return TInstant::Seconds(date.GetStart()) + TDuration::Hours(hours + 1);
    }
}
