#pragma once

#include <passport/infra/daemons/logstoreapi/src/utils/data_types.h>

#include <util/datetime/base.h>

namespace NPassport::NLogstoreApi {
    class ITimeAggregator;
    using TTimeAggregatorPtr = std::unique_ptr<ITimeAggregator>;

    class ITimeAggregator {
    public:
        virtual ~ITimeAggregator() = default;
        virtual TString GetSuffix(TInstant ins) const = 0;
        virtual TInstant GetDeadline(TInstant ins) const = 0;

        static TTimeAggregatorPtr Create(ETimeAggregation type);
    };

    class TDayAggregator: public ITimeAggregator {
    public:
        TString GetSuffix(TInstant ins) const final;
        TInstant GetDeadline(TInstant ins) const final;
    };

    class THourAggregator: public ITimeAggregator {
    public:
        TString GetSuffix(TInstant ins) const final;
        TInstant GetDeadline(TInstant ins) const final;
    };
}
