LIBRARY()

OWNER(g:passport_infra)

PEERDIR(
    library/cpp/streams/zstd
    library/cpp/threading/future
    passport/infra/libs/cpp/logbroker/resource_dispatcher
    passport/infra/libs/cpp/tvm/common
    passport/infra/libs/cpp/tvm/logger
    passport/infra/libs/cpp/unistat
    passport/infra/libs/cpp/utils
    util/draft
)

SRCS(
    logstoreapi.cpp
    processor.cpp

    logger/logger.cpp

    parsers/plain_text_parser.cpp

    utils/converter.cpp
    utils/data_types.cpp
    utils/extractor.cpp
    utils/tz_msk.cpp

    writers/log_aggregator.cpp
    writers/logs_manager.cpp
    writers/sequencer.cpp
    writers/simple_writer.cpp
    writers/time_aggregator.cpp
)

GENERATE_ENUM_SERIALIZATION(utils/data_types.h)
GENERATE_ENUM_SERIALIZATION(writers/sequencer.h)

END()
