#include "common.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

using namespace NPassport;
namespace NPassport::NLogstoreApi {
    NThreading::TFuture<void> TFakeWriter::Write(const TChunk& chunk) {
        Offset_ = chunk.Roffset();
        if (chunk.Error()) {
            Output_.append("ERROR: ").append(*chunk.Error()).append("\n");
        }
        for (const TLogLine& line : chunk.Lines()) {
            Output_.append(line.Line);
        }
        return NThreading::MakeFuture();
    }

    const TString& TFakeWriter::Output() const {
        return Output_;
    }

    size_t TFakeWriter::Offset() const {
        return Offset_;
    }

    void TFakeWriter::AddUnistat(NUnistat::TBuilder& builder) {
        Y_UNUSED(builder);
    }

    std::unique_ptr<TChunk> MakeChunk(const TString& file, const TString& host, std::vector<TString>&& logs, size_t initialOffset) {
        std::vector<TLogLine> lines;
        size_t offset = initialOffset;
        for (TString& log : logs) {
            lines.push_back(TLogLine{
                .Timestamp = TInstant::Now(),
                .Line = NUtils::CreateStr(log, '\n'),
                .Offset = offset,
            });
            offset += lines.rbegin()->Line.size();
        }

        return std::make_unique<TChunk>(TStreamInfo{
                                            .File = file,
                                            .Host = host,
                                        }, std::move(lines));
    }

    NThreading::TFuture<void> TTestWriter::Write(const TChunk& chunk) {
        Y_ENSURE(chunk.Offset() == Offset_);
        Offset_ = chunk.Roffset();
        return NThreading::MakeFuture();
    }

}
