#pragma once

#include <passport/infra/daemons/logstoreapi/src/utils/data_types.h>
#include <passport/infra/daemons/logstoreapi/src/writers/base_writer.h>

using namespace NPassport;
namespace NPassport::NLogstoreApi {
    class TFakeWriter: public IWriter {
    public:
        NThreading::TFuture<void> Write(const TChunk& chunk) override;

        const TString& Output() const;

        size_t Offset() const;

        void AddUnistat(NUnistat::TBuilder& builder) override;

    private:
        TString Output_;
        size_t Offset_ = 0;
    };

    std::unique_ptr<TChunk> MakeChunk(const TString& file, const TString& host, std::vector<TString>&& logs, size_t initialOffset = 0);

    class TTestWriter: public IWriter {
        NThreading::TFuture<void> Write(const TChunk& chunk) override;

    private:
        size_t Offset_;
    };

    class TNamedWriter: public IWriter {
    public:
        TNamedWriter(const TString& filename)
            : Filename(filename)
        {
        }

        NThreading::TFuture<void> Write(const TChunk&) override {
            return NThreading::MakeFuture();
        }

        void AddUnistat(NUnistat::TBuilder&) override {
        }

        TString Filename;
    };

    class TNamedWriterFactory: public IWriterFactory {
    public:
        TWriterPtr CreateWriter(const TString& filename) const override {
            return std::make_shared<TNamedWriter>(filename);
        }
    };
}
