#include "common.h"

#include <passport/infra/daemons/logstoreapi/src/utils/data_types.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NLogstoreApi;

Y_UNIT_TEST_SUITE(DataTypes) {
    Y_UNIT_TEST(TChunk) {
        std::vector<TLogLine> logs;
        logs.push_back({
            .Line = "more random data",
            .Offset = 125,
        });
        logs.push_back({
            .Line = "asdf",
            .Offset = 0,
        });
        logs.push_back({
            .Line = "[debug] Moderately long log line found in log file file.log with level debug used for tests in ascii format",
            .Offset = 5,
        });
        logs.push_back({
            .Line = "some more random data",
            .Offset = 142,
        });
        logs.push_back({
            .Line = "random data",
            .Offset = 113,
        });
        TChunk chunk(TStreamInfo{
                         .File = "file.log",
                         .Host = "host.passport.yandex.net",
                     }, std::move(logs));

        UNIT_ASSERT_VALUES_EQUAL(chunk.Offset(), 0);
        UNIT_ASSERT_VALUES_EQUAL(chunk.Roffset(), 163);
        UNIT_ASSERT(!chunk.empty());

        ui64 offset = 0;
        for (const TLogLine& log : chunk.Lines()) {
            UNIT_ASSERT_VALUES_EQUAL(offset, log.Offset);
            offset += log.Line.size() + 1;
        }

        UNIT_ASSERT_VALUES_EQUAL(chunk.Roffset() + 1, offset);
    }

    Y_UNIT_TEST(TChunkSlice) {
        std::unique_ptr<TChunk> chunk = MakeChunk("unused file", "unused host", {
                                                                                    "abcdef\n", "janfsdkjfnalsdjfn\n",
                                                                                }, 100);

        UNIT_ASSERT(!chunk->Slice(0));
        UNIT_ASSERT_VALUES_EQUAL(100, chunk->Offset());
        UNIT_ASSERT(chunk->Slice(100));
        UNIT_ASSERT_VALUES_EQUAL(100, chunk->Offset());
        UNIT_ASSERT(!chunk->Slice(101));
        UNIT_ASSERT_VALUES_EQUAL(100, chunk->Offset());
        UNIT_ASSERT(chunk->Slice(108));
        UNIT_ASSERT_VALUES_EQUAL(108, chunk->Offset());
        UNIT_ASSERT(!chunk->Slice(109));
        UNIT_ASSERT_VALUES_EQUAL(108, chunk->Offset());
        UNIT_ASSERT(!chunk->Slice(127));
        UNIT_ASSERT_VALUES_EQUAL(108, chunk->Offset());
    }
}
