#include <passport/infra/daemons/logstoreapi/src/utils/data_types.h>

#include <util/stream/output.h>

using namespace NPassport::NLogstoreApi;

template <>
void Out<TLogLine>(IOutputStream& out, const TLogLine& value) {
    out << value.Offset << " (" << value.Timestamp.Seconds() << "." << value.Timestamp.MicroSecondsOfSecond() << ")"
        << ": " << value.Line;
}

template <>
void Out<TChunk>(IOutputStream& out, const TChunk& value) {
    out << value.Host() << " : " << value.File() << " | ";
    out << "(" << value.Offset() << " -> " << value.Roffset() << ")" << Endl;
    for (const TLogLine& line : value.Lines()) {
        out << line << Endl;
    }
}
