#include <passport/infra/daemons/logstoreapi/src/parsers/plain_text_parser.h>

#include <passport/infra/libs/cpp/utils/string/coder.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/string/split.h>

using namespace std::string_literals;

using namespace NPassport;
using namespace NPassport::NLogstoreApi;

Y_UNIT_TEST_SUITE(PlainTextParser) {
    Y_UNIT_TEST(ParseSuccess) {
        std::vector<TString> tests = {
            // Few normal messages
            "Some text\nSome more text\neven more text\n",
            "Текст, но киррилица\nЕще немного текста\n",
            "kz{nHow<LD*-85!zWe^s=V!RxkPQ/=f1L.9[+Dx3xtZbPXm-a[2=aG1[2q%Cs-Cp^*AS!NgMf1&L(,&vpz(WdHHJ%w|0|Vw&^urc\n"
            "272896 hP]bw9uwW9Q.+k}y&)[OE4<xD~x.]yIEpzJP(mImWLA2(ZyBTHGhIt[^Pvf_n,Eng}\\'<zF+%)8#kpgGTf{Iq!cOosa4UQ.NnN2-\n"
            "272897 ,sD|v`szon[[}j'P*MRm{zoF?_F4+;XlAzFV%}aL0#4Q=Q`rN#~}k=)@Oe2L|H/Xw.?K[!lNDu_%vs4:KFGC2CFM[`s=a4'xMPN-\n"
            "272898 \"P-K4>^Kv`~8st#g4w1+=R;_ibLH)Y&b5E\\x#f[~!\\/!GkB=|B$Uj^VdhAk2eRa.o_6|c-DXl<DVZn8:z!'>dnr`qpl~CZ{f~QlU\n"
            "272899 7AFn/\";aqrih#pKwQq9!N*(r}zTs'@~2GGx}|Xu?JxdRE]/uGoVljL\\Znl?Z0]_sc{@Ik+#*g/yG0T$,NF#U\\U7(t;E%.4!o#RG4\n"
            "272900 2pU>#hg[f'ktV;g=O$4aQN94l>Rux4gS|0G#+N_u0YzUAckm%/*w}2EJ`'Hz\\uar'\")U5lD/~)^lW(p*L'XLC{TH-t1(w_N$I8Rx\n\n\n\n\n\n\n"
            "272901 dON#-T6^a]:N@PR3hxvo5x,sOj+M2_lS_u%(ZvEO=bv$t5f-V31JN}#.W[U$HRNFXS#E.G\\S_gOL^+3Mc_lRIEsRp*{>N+A6rvH%\n"
            "272902 6lo4+Uy6v2jj<7d}y1y;C1Oi7cL1]2yl+*l,)Tboq5O^hglLHs)9`@]WFKBz7`nHNf0DU5;S8daT=`A!%[yj,yI2w\"4nm3..UY[a\n"
            "272903 ~ku\"N0Og<4tDQd<wrB@D\\Qb$[xp~xw>l_#:*@}1k*VsVvjohU?`6'5h4cq*&!.TNUpE[_kGsszR[<G'TG=S/)aklLB7v|B_|H9l{\n"
            "272904 VEVwz:0;:E|5]IB4<vNAYW;e8DMC-${}lYl-lST*J*?rJPWPFhydiP/w(-1fR%N:Y4z`*dhb}dlH[:0oTdp:.R-Lw}]5RA&%\"V|u\n",
        };
        std::vector<std::vector<TLogLine>> results;
        results.emplace_back();
        results[0].push_back(TLogLine{
            .Line = "Some text\n",
            .Offset = 100500,
        });
        results[0].push_back(TLogLine{
            .Line = "Some more text\n",
            .Offset = 100510,
        });
        results[0].push_back(TLogLine{
            .Line = "even more text\n",
            .Offset = 100525,
        });

        results.emplace_back();
        results[1].push_back(
            TLogLine{
                .Line = "Текст, но киррилица\n",
                .Offset = 100500,
            });

        results[1].push_back(
            TLogLine{
                .Line = "Еще немного текста\n",
                .Offset = 100536,
            });

        results.emplace_back();
        std::vector<TString> tmp = StringSplitter(tests[2]).Split('\n');
        tmp.pop_back();
        size_t offset = 100500;

        for (TString& s : tmp) {
            s.push_back('\n');
            results[2].push_back(
                TLogLine{
                    .Line = s,
                    .Offset = offset,
                });

            offset += s.size();
        }

        for (size_t i = 0; i < results.size(); ++i) {
            TPlainTextParser parser(100500);
            std::vector<TLogLine> output = parser.Parse(tests[i]);

            UNIT_ASSERT_VALUES_EQUAL(output.size(), results[i].size());
            for (size_t j = 0; j < output.size(); ++j) {
                UNIT_ASSERT_VALUES_EQUAL(output[j].Timestamp, results[i][j].Timestamp);
                UNIT_ASSERT_VALUES_EQUAL(output[j].Offset, results[i][j].Offset);
                UNIT_ASSERT_VALUES_EQUAL(output[j].Line, results[i][j].Line);
            }
        }
    }

    Y_UNIT_TEST(ParseFail) {
        TPlainTextParser p(0);
        UNIT_ASSERT_EXCEPTION_CONTAINS(p.Parse("asdfasudhfo\nasdfas"), yexception, "Chunk must end with endline");
        UNIT_ASSERT_EXCEPTION_CONTAINS(p.Parse("\n\n\n\n\n\n\n\na"), yexception, "Chunk must end with endline");
    }
}
