#include <passport/infra/daemons/logstoreapi/src/utils/tz_msk.h>
#include <passport/infra/daemons/logstoreapi/src/writers/time_aggregator.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>

using namespace NPassport;
using namespace NPassport::NLogstoreApi;

Y_UNIT_TEST_SUITE(TimeAggregator) {
    Y_UNIT_TEST(Factory) {
        SetTzMsk();

        UNIT_ASSERT_VALUES_EQUAL(
            "19700426",
            ITimeAggregator::Create(ETimeAggregation::Day)->GetSuffix(TInstant::Seconds(10009000)));
        UNIT_ASSERT_VALUES_EQUAL(
            "1970042623",
            ITimeAggregator::Create(ETimeAggregation::Hour)->GetSuffix(TInstant::Seconds(10009000)));
    }

    Y_UNIT_TEST(DayAggregator) {
        SetTzMsk();

        TDayAggregator a;

        UNIT_ASSERT_VALUES_EQUAL("19700426", a.GetSuffix(TInstant::Seconds(10009000)));
        UNIT_ASSERT_VALUES_EQUAL("20210929", a.GetSuffix(TInstant::Seconds(1632943104)));

        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-04-27T00:00:00.000000+03"),
                                 a.GetDeadline(TInstant::Seconds(10009000)));
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("2021-09-30T00:00:00.000000+03"),
                                 a.GetDeadline(TInstant::Seconds(1632943104)));
    }

    Y_UNIT_TEST(HourAggregator) {
        SetTzMsk();

        THourAggregator a;

        UNIT_ASSERT_VALUES_EQUAL("1970042623", a.GetSuffix(TInstant::Seconds(10009000)));
        UNIT_ASSERT_VALUES_EQUAL("2021092922", a.GetSuffix(TInstant::Seconds(1632943104)));

        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("1970-04-27T00:00:00.000000+03"),
                                 a.GetDeadline(TInstant::Seconds(10009000)));
        UNIT_ASSERT_VALUES_EQUAL(TInstant::ParseIso8601("2021-09-29T23:00:00.000000+03"),
                                 a.GetDeadline(TInstant::Seconds(1632943104)));
    }
}
