import sys


ENV_MAPPING = {
    "rc": "production",
}


SETTINGS = {
    "development": {
        "THREADS": 8,
        "BB_POOL_SIZE": 8,
        "BB_HOST": "blackbox-test.yandex.net",
        "TVM_SELF_ID": 2031374,
        "TVM_BB_ID": 224,
    },
    "testing": {
        "THREADS": 8,
        "BB_POOL_SIZE": 8,
        "BB_HOST": "blackbox-test.yandex.net",
        "TVM_SELF_ID": 2031372,
        "TVM_BB_ID": 224,
    },
    "production": {
        "THREADS": 16,
        "BB_POOL_SIZE": 16,
        "BB_HOST": "blackbox.yandex.net",
        "TVM_SELF_ID": 2031370,
        "TVM_BB_ID": 222,
    },
}


def do(template, env):
    env = ENV_MAPPING.get(env, env)

    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('{{%s}}' % key, str(value))

    if '{{' in template or '}}' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
