#pragma once
// DO_NOT_STYLE
#include <util/generic/string.h>

#include <cctype>
#include <functional>
#include <map>

namespace NPassport::NMda::NCommon {

//
// Case-insensitive string map
//
// BUG Cookies are case sensitive. We are afraid to touch everybody so we do only one fix:
// to behead MDA
struct CiStrLess {
    bool operator()(const TString& x, const TString& y) const {
        if (x.size() != y.size()) {
            return x.size() < y.size();
        }

        if (3 == x.size() && x[1] == 'd' && ("mda" == x || "mda" == y)) {
            return x < y;
        }
        TString::const_iterator xit = x.begin();
        TString::const_iterator yit = y.begin();
        while (xit != x.end()) {
            char ux = std::toupper(*xit++);
            char uy = std::toupper(*yit++);
            if (ux < uy) {
                return true;
            }
            if (ux > uy) {
                break;
            }
        }
        return false;
    }
};
using cistrmap_t = std::map<TString, TString, CiStrLess>;

}
