#include "common_module.h"
// DO_NOT_STYLE

#include "util.h"

#include <passport/infra/libs/cpp/xml/config.h>
#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/utils/log/global.h>
#include <passport/infra/libs/cpp/utils/string/format.h>
#include <passport/infra/libs/cpp/utils/string/split.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NMda::NCommon {

TString CommonModule::GetArg(const TReqCtx& ctx, const TString& argName) {
    TString leftOutSample;
    TString value = ctx.Request->GetArg(argName);

    // If it contains any non-printable characters, leave those out, but proceed
    // (MDA-102, MDA-113)
    if (!Utils::CheckAndSuppressNonprintable(value, leftOutSample)) {
        TLog::Info("Request with parameter %s containing non-printable characters; sample: %s; corrected as: %s", argName.c_str(), Utils::Logencode(leftOutSample).c_str(), value.c_str());
    }

    return value;
}

//
// Misc. utils
//

static const TString sessionIdStr("Session_id");
MyCookieMap::MyCookieMap(const TString& header)
{
    // Split Cookie: header by the ';' or ',' char
    using scipair = std::pair<TString::const_iterator, TString::const_iterator>;
    using scivectype = std::vector<scipair>;
    scivectype pairvec;
    NUtils::Transform(header, ";,", [&pairvec](const TStringBuf buf) -> void {
        pairvec.push_back(std::make_pair(buf.begin(), buf.end()));
    });

    TString name;
    TString value;
    name.reserve(32);
    value.reserve(256);

    // For every found av-pair
    for (scivectype::const_iterator cooit = pairvec.begin(); cooit != pairvec.end(); ++cooit) {
        // Separate name from value
        TString::const_iterator eqit;
        TString::const_iterator valstart = cooit->second;
        for (eqit = cooit->first; eqit != cooit->second; ++eqit) {
            if (*eqit == '=') {
                valstart = eqit;
                ++valstart;
                break;
            }
        }
        // Strip whitespace off the name
        TString::const_iterator namestart = cooit->first;
        while (namestart != eqit && ((*namestart) == ' ' || (*namestart) == '\t')) {
            ++namestart;
        }
        TString::const_iterator nameend = namestart;
        while (nameend != eqit && (*nameend) != ' ' && (*nameend) != '\t') {
            ++nameend;
        }
        if (namestart == nameend) {
            continue;
        }
        name.assign(namestart, nameend);
        // Strip whitespace off the value
        while (valstart != cooit->second && ((*valstart) == ' ' || (*valstart) == '\t')) {
            ++valstart;
        }
        TString::const_iterator valend = cooit->second;
        while (valend != valstart) {
            --valend;
            if ((*valend) != ' ' && (*valend) != '\t') {
                ++valend;
                break;
            }
        }
        // Strip quotes off the value
        if (*valstart == '"' && valstart != valend) {
            --valend;
            if (valstart == valend || *valend != '"') {
                ++valend;
            } else {
                ++valstart;
            }
        }
        value.assign(valstart, valend);

        // Now insert this pair into the map
        cistrmap_t::iterator mapit = Cookies_.find(name);
        if (mapit != Cookies_.end()) {
            if (name != sessionIdStr) {
                continue;
        }
            // Dirty hack!!! Need to workaround Opera bug, sending sometimes
            // two (or more?) Session_id cookies (assigned to different host
            // names); choose the most recent one.
            if (mapit->second < value) {
                mapit->second.assign(value);
            } else {
                continue;
            }
        }
        Cookies_.insert(mapit, cistrmap_t::value_type(name, value));
    }
}

bool MyCookieMap::Get(const TString& name, TString& value) const {
    cistrmap_t::const_iterator mapit = Cookies_.find(name);
    if (mapit == Cookies_.end()) {
        return false;
    }
    value.assign(mapit->second);
    return true;
}
}
