#pragma once
// DO_NOT_STYLE
#include "cistrmap.h"

#include <passport/infra/libs/cpp/request/request.h>

namespace NPassport::NMda::NCommon {

//
// Cookie container -- implement our own instead of baida's because baida's container:
//  - doesn't allow space in cookie values
//  - is case-sensitive
//  - request::get_cookie() invokes parser each time and URL-decodes the value
//  - cgi::cookie() URL-decodes the value (need iterate manually over entire container every time)
//  - doesn't support ',' as the separator (which we intend to support in the future)
//  - seems to have other subtle bugs in the parser
//
class MyCookieMap {
public:
    explicit MyCookieMap(const TString& header);

    bool Get(const TString& name, TString& value) const;

private:
    cistrmap_t Cookies_;
};

//
// Common wrapper for the HTTP request data structure
//
static const TString cookieHeaderStr("cookie");
static const TString refererHeaderStr("referer");

class TReqCtx {
public:
    explicit TReqCtx(NPassport::NCommon::TRequest* req)
        : Request(req)
        , Cookies(req != nullptr ? req->GetHeader(cookieHeaderStr) : TString())
        , Userip(req->GetRemoteAddr())
        , Referer(req->GetHeader(refererHeaderStr))
        , Host(req->GetHost()) {
        if (Referer.size() > 500) {
            Referer.resize(500);
        }
    }

    NPassport::NCommon::TRequest* Request;
    MyCookieMap Cookies;
    TString Userip;
    TString Referer;
    TString Host;
};

}
