#include "util.h"
// DO_NOT_STYLE

#include "req_ctx.h"

#include <passport/infra/libs/cpp/utils/string/format.h>
#include <passport/infra/libs/cpp/utils/string/string_utils.h>

#include <regex>

namespace NPassport::NMda::NCommon {

// Yes! We pretend '_' is a valid character in a host name; otherwise, yandex.ru_foobar.net will
// be allowed through as a valid yandex.ru host name, whereas browsers may interpret it as
// foobar.net host name (MDA-117).
//
// We're not interested in port number, just host name
static const std::regex HOST_REGEX("^(http(s)?://)?([[:alnum:]._-]+)(:[0-9]+)?([/?]|$)");

TString
Utils::HostFromUri(const TString& uri) {
    std::smatch results;
    if (std::regex_search(uri.cbegin(), uri.cend(), results, HOST_REGEX)) {
        return NUtils::TolowerCopy(results.str(3));
    }
    return {};
}

bool Utils::CheckAndSuppressNonprintable(TString& value, TString& sample) {
    TString::size_type samplePos = TString::npos;
    TString cleanValue;
    cleanValue.reserve(value.size());

    // Copy value leaving out any non-printable characters along the way. If we meet
    // any, remember position of the first occurence - we'll save a sample for
    // logging later.
    for (TString::size_type i = 0; i < value.size(); ++i) {
        if ((unsigned)value[i] < 128 && !std::isprint(value[i])) {
            if (samplePos == TString::npos) {
                samplePos = i;
        }
        } else {
            cleanValue.push_back(value[i]);
        }
    }

    // No non-printable characters so the value is OK, do nothing.
    if (samplePos == TString::npos) {
        return true;
}

    // Extract a sample for the original value, then return cleaned up variant.
    samplePos = samplePos > 50 ? samplePos - 50 : 0;
    TString::size_type sampleEnd = samplePos + 100;
    sample.assign(value, samplePos, sampleEnd - samplePos);

    value = std::move(cleanValue);

    return false;
}

static const char hexchars[] = "0123456789ABCDEF";

TString
Utils::Logencode(const TString& src) {
    TString str;
    int len = src.size();
    str.reserve(len);
    for (int x = 0, y = 0; len--; ++x, ++y) {
        str.push_back(src[x]);
        if ((unsigned)str[y] < 128 && (!isprint(str[y]) || str[y] == ' ')) {
            /* Allow only printable chars; escape the rest */
            str[y] = '0';
            str += 'x';
            ++y;
            str += hexchars[(unsigned char)src[x] >> 4];
            ++y;
            str += hexchars[(unsigned char)src[x] & 0x0F];
            ++y;
        }
    }
    return str;
}
}
