#pragma once
// DO_NOT_STYLE
#include <passport/infra/daemons/sezamapi/src/sids/sids_accounts.h>

#include <passport/infra/libs/cpp/dbpool/handle.h>

#include <memory>
#include <regex>
#include <set>
#include <stdexcept>
#include <stdint.h>

namespace NPassport::NCommon {
class TRequest;
}
namespace NPassport::NUnistat {
class TBuilder;
}
namespace NTvmAuth {
    class TTvmClient;
}
namespace NPassport::NXml {
class TConfig;
}

namespace NPassport::NMda::NCommon {
class TReqCtx;
}

namespace NPassport::NMda {

class Sids {
public:
    Sids();
    ~Sids();

    void Init(const NXml::TConfig& config);

    void HandleRequest(NPassport::NCommon::TRequest& request);

    void AddUnistat(NUnistat::TBuilder& builder);

private:
    void ProcessNagios(NPassport::NCommon::TRequest* request);
    void ProcessAccounts(NCommon::TReqCtx& ctx);

    using ServeDomains = std::map<TString, TString>;
    using ServeDomainsCIter = ServeDomains::const_iterator;
    ServeDomainsCIter GetServeDomain(const TString& host);
    std::pair<TString, TString> GetDomainInfo(const TString& host);
    void InitTvm(const NXml::TConfig& config, const TString& componentXPath);
    void InitServeDomains(const NPassport::NXml::TConfig* config, const TString& componentXPath);
    bool InitFailed() const;
    bool CheckCsrf(NCommon::TReqCtx& ctx, const TString& sess_cookie) const;

    static void SendAccountsList(NCommon::TReqCtx& ctx, const TString& callback, const NSezamApi::TAccounts* accounts = nullptr);

    bool IsForceDown() const;
    static void Serialize(const NSezamApi::TPersonalInfo& info, TString& buf, bool escape);

private:
    bool InitFailed_ = true;
    std::shared_ptr<NDbPool::TDbPoolCtx> DbCtx_;
    std::shared_ptr<NDbPool::TDbPool> BlackboxDb_;
    std::shared_ptr<NTvmAuth::TTvmClient> TvmClient_;

    ServeDomains ServeDomains_;
    std::unique_ptr<NSezamApi::TAccountsSettings> AccountsSettings_;
    bool EnableYandexuidCheck_ = false;
    TString RootKeyspace_;
    TString ForceDownFile_;

    static const std::regex callbackRegex_;
};

}
