import json
import sys


SETTINGS = {
    "development": {
        "SELF_TVM_ID": "2024483",
        "IDM_SYSTEM_SLUG": "passportparmadev",
        "MYSQL_SERVER": "cnt-dbm-test.passport.yandex.net",
        "EXTRA_FIELDS": "",
    },
    "testing": {
        "SELF_TVM_ID": "2024481",
        "IDM_SYSTEM_SLUG": "passportparmatest",
        "MYSQL_SERVER": "pharma-dbs.passport.yandex.net",
        "EXTRA_FIELDS": '"testing_numbers_file": "/etc/yandex/passport-pharmaapi/testing_numbers",',
    },
    "production": {
        "SELF_TVM_ID": "2024479",
        "IDM_SYSTEM_SLUG": "passportparmaprod",
        "MYSQL_SERVER": "pharma-dbs.passport.yandex.net",
        "EXTRA_FIELDS": "",
    },
}

SETTINGS_FROM_FILE = {
    "MYSQL_LOGIN": "/etc/yandex/passport-pharmaapi/mysql.login",
    "MYSQL_PASSWORD": "/etc/yandex/passport-pharmaapi/mysql.password",
}


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, str(value))

    for key, value in SETTINGS_FROM_FILE.items():
        with open(value) as f:
            template = template.replace('<<%s>>' % key, str(f.read()))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]), file=sys.stderr)
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
