#pragma once

#include "output/aggregates_chunk.h"

#include <library/cpp/containers/stack_vector/stack_vec.h>

#include <util/datetime/base.h>

#include <unordered_set>

namespace NPassport::NPharmaApi::NPrivate {
    template <typename T>
    class TUniquePolicy {
    public:
        void Reserve(size_t reserve) {
            Unique_.reserve(reserve);
        }

        void Process(const T& value) {
            Unique_.insert(value);
        }

        size_t GetValue() const {
            return Unique_.size();
        }

    private:
        std::unordered_set<T> Unique_;
    };

    class TTotalPolicy {
    public:
        void Reserve(size_t) {
        }

        void Process() {
            ++Value_;
        }

        size_t GetValue() const {
            return Value_;
        }

    private:
        size_t Value_ = 0;
    };

    template <class PolicyType>
    class TAggregatesHelper {
    public:
        TAggregatesHelper(size_t reserve = 0) {
            constexpr time_t hour = 3600;
            constexpr time_t day = 3600 * 24;
            constexpr time_t month = 3600 * 24 * 30;
            constexpr time_t year = 3600 * 24 * 30 * 12;

            for (time_t tsDelta : {hour, day, month, year}) {
                Groups_.push_back(TGroup{.MaxTsDelta = tsDelta});
                Groups_.back().Policy.Reserve(reserve);
            }
        }

        template <typename... Args>
        void Add(time_t tsDelta, const Args&... value) {
            for (TGroup& group : Groups_) {
                if (tsDelta < group.MaxTsDelta) {
                    group.Policy.Process(value...);
                }
            }
        }

        TAggregateChunk Finish() {
            return TAggregateChunk{
                .LastHour = Groups_[0].Policy.GetValue(),
                .LastDay = Groups_[1].Policy.GetValue(),
                .LastMonth = Groups_[2].Policy.GetValue(),
                .LastYear = Groups_[3].Policy.GetValue(),
            };
        }

    public:
        struct TGroup {
            time_t MaxTsDelta = 0;
            PolicyType Policy;
        };

    private:
        TStackVec<TGroup, 4> Groups_;
    };
}

namespace NPassport::NPharmaApi {
    template <typename T>
    using TUniqueAggregator = NPrivate::TAggregatesHelper<NPrivate::TUniquePolicy<T>>;

    using TTotalAggregator = NPrivate::TAggregatesHelper<NPrivate::TTotalPolicy>;
}
