#pragma once

#include "runtime_context.h"
#include "output/factors_by_number_result.h"

#include <util/generic/string.h>

#include <time.h>

namespace NPassport::NCommon {
    class TRequest;
}

namespace NPassport::NDbPool {
    class TDbPool;
    struct TTable;
}

namespace NPassport::NPharmaApi {
    class TFactorsByNumberProcessor {
    public:
        TFactorsByNumberProcessor(const TRuntimeContext& runtime);
        TFactorsByNumberProcessor(NDbPool::TDbPool& db,
                                  const NGeobase::IGeobase& geobase,
                                  const TFactorsSettings settings,
                                  const TTestingNumbers& testingNumbers);

        TFactorsByNumberResult Process(const NCommon::TRequest& request);

        static TFactorsByNumberResult::TFactors CalculateFactors(
            NDbPool::TTable table,
            const TFactorsSettings& settings,
            const NGeobase::IGeobase& geobase,
            const time_t now = time(nullptr));

    private:
        NDbPool::TTable FetchFromDb(const TString& number) const;

    private:
        NDbPool::TDbPool& Db_;
        const NGeobase::IGeobase& Geobase_;
        const TFactorsSettings Settings_;
        const TTestingNumbers& TestingNumbers_;
    };
}
