#include "number_meta_helper.h"

#include <contrib/libs/libphonenumber/cpp/src/phonenumbers/phonenumberutil.h>

#include <util/generic/yexception.h>

using namespace i18n::phonenumbers;

namespace NPassport::NPharmaApi {
    TNumberMetaChunk TNumberMetaHelper::Process(const TString& number) {
        auto u = PhoneNumberUtil::GetInstance();
        PhoneNumber phoneNum;

        Y_ENSURE(PhoneNumberUtil::NO_PARSING_ERROR == u->Parse("+" + number, "ZZ", &phoneNum),
                 "failed to parse number");

        std::string nationSigNumber;
        u->GetNationalSignificantNumber(phoneNum, &nationSigNumber);
        int operatorCodeLength = u->GetLengthOfNationalDestinationCode(phoneNum);

        std::string e164;
        u->Format(phoneNum, PhoneNumberUtil::E164, &e164);

        std::string region;
        u->GetRegionCodeForNumber(phoneNum, &region);
        if (region == "ZZ") {
            region.clear();
        }

        return TNumberMetaChunk{
            .CountryCode = phoneNum.Getcountry_code(),
            .OperatorCode = TString(TStringBuf(nationSigNumber).substr(0, operatorCodeLength)),
            .E164 = TString(e164),
            .Region = TString(region),
        };
    }
}
