#pragma once

#include "aggregates_chunk.h"
#include "counts_chunk.h"
#include "number_meta_chunk.h"

#include <optional>

namespace NPassport::NPharmaApi {
    struct TFactorsByNumberResult {
        struct TFactors {
            TCountsChunk Bindings;
            TCountsChunk Usages;

            TAggregateChunk UniqUids;
            TAggregateChunk UniqIp;
            TAggregateChunk UniqAs;
            TAggregateChunk UniqUserAgent;

            bool operator==(const TFactors& o) const {
                return Bindings == o.Bindings &&
                       Usages == o.Usages &&
                       UniqUids == o.UniqUids &&
                       UniqIp == o.UniqIp &&
                       UniqAs == o.UniqAs &&
                       UniqUserAgent == o.UniqUserAgent;
            }
        };

        std::optional<TNumberMetaChunk> NumberMeta;
        TFactors Factors;

        bool operator==(const TFactorsByNumberResult& o) const {
            return NumberMeta == o.NumberMeta &&
                   Factors == o.Factors;
        }
    };
}
