#include "serializer.h"

#include "factors_by_number_result.h"

#include <passport/infra/libs/cpp/json/writer.h>

namespace NPassport::NPharmaApi {
    TString TSerializer::SerializeError(const std::exception& e) {
        TString buf;
        NJson::TWriter wr(buf);
        NJson::TObject root(wr);

        root.Add("error", e.what());

        return buf;
    }

    TString TSerializer::SerializeError(const TStringBuf e) {
        TString buf;
        NJson::TWriter wr(buf);
        NJson::TObject root(wr);

        root.Add("error", e);

        return buf;
    }

    static void SerializeChunk(const TCountsChunk& chunk,
                               TStringBuf name,
                               NJson::TObject& obj) {
        NJson::TObject o(obj, name);

        o.Add("last_hour", chunk.Counters.LastHour);
        o.Add("last_day", chunk.Counters.LastDay);
        o.Add("last_month", chunk.Counters.LastMonth);
        o.Add("last_year", chunk.Counters.LastYear);
        o.Add("maybe_more", chunk.MaybeMore);
    }

    static void SerializeChunk(const TAggregateChunk& chunk,
                               TStringBuf name,
                               NJson::TObject& obj) {
        NJson::TObject o(obj, name);

        o.Add("last_hour", chunk.LastHour);
        o.Add("last_day", chunk.LastDay);
        o.Add("last_month", chunk.LastMonth);
        o.Add("last_year", chunk.LastYear);
    }

    static const TString NUMBER_META = "number_meta";

    TString TSerializer::Serialize(const TFactorsByNumberResult& result) {
        TString buf;
        NJson::TWriter wr(buf);
        NJson::TObject root(wr);

        if (result.NumberMeta) {
            const TNumberMetaChunk& chunk = *result.NumberMeta;

            NJson::TObject meta(root, NUMBER_META);
            meta.Add("country_code", chunk.CountryCode);
            meta.Add("operator_code", chunk.OperatorCode);
            meta.Add("e164", chunk.E164);
            meta.Add("region", chunk.Region);
        } else {
            root.Add(NUMBER_META, nullptr);
        }

        NJson::TObject factors(root, "factors");

        SerializeChunk(result.Factors.Bindings, "bindings", factors);
        SerializeChunk(result.Factors.Usages, "usages", factors);

        SerializeChunk(result.Factors.UniqUids, "unique_uids", factors);
        SerializeChunk(result.Factors.UniqIp, "unique_ip", factors);
        SerializeChunk(result.Factors.UniqAs, "unique_as", factors);
        SerializeChunk(result.Factors.UniqUserAgent, "unique_user_agent", factors);

        return buf;
    }
}
