#pragma once

#include <passport/infra/libs/cpp/request/request.h>
#include <passport/infra/libs/cpp/unistat/consumers.h>
#include <passport/infra/libs/cpp/unistat/handle.h>

#include <util/generic/string.h>

#include <memory>

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NUtils {
    class TFileLogger;
}

namespace NPassport::NPharmaApi {
    class TRuntimeContext;

    class TPharmaApi {
    public:
        TPharmaApi();
        ~TPharmaApi();

        void Init(const NJson::TConfig& config);

        void HandleRequest(NCommon::TRequest& request);

        void AddUnistat(NUnistat::TBuilder& builder);

    private:
        void InitLogs(const NJson::TConfig& config, const TString& path);

        void HandleImpl(NCommon::TRequest& req);

        static void CheckDuplicatedArgs(const NCommon::TRequest& req);

        void HandlePing(NCommon::TRequest& req);
        void HandleHealthCheck(NCommon::TRequest& req);
        void HandleFactorsByNumber(NCommon::TRequest& req);

        void LogAccess(const NCommon::TRequest& req, TDuration spent);

        void CheckAuth(NCommon::TRequest& req, TStringBuf expectedRole) const;
        static void CheckHttpMethod(const NCommon::TRequest& req, TStringBuf expectedMethod);

    private:
        std::unique_ptr<NUtils::TFileLogger> AccessLog_;
        std::unique_ptr<TRuntimeContext> Runtime_;

        THashMap<TString, std::function<void(NCommon::TRequest&)>> Handlers_;
        NUnistat::THandles UnistatHandles_;
    };
}
