#pragma once

#include <util/generic/hash_set.h>
#include <util/generic/string.h>

#include <memory>
#include <optional>

namespace NPassport::NDbPool {
    class TDbPool;
    class TDbPoolCtx;
}

namespace NPassport::NGeobase {
    class IGeobase;
}

namespace NPassport::NJson {
    class TConfig;
}

namespace NPassport::NUnistat {
    class TBuilder;
}

namespace NPassport::NJuggler {
    class TStatus;
}

namespace NTvmAuth {
    class TTvmClient;
}

namespace NPassport::NPharmaApi {
    struct TFactorsSettings {
        size_t Limit = 1000;
    };

    using TTestingNumbers = std::optional<THashSet<TString>>;

    class TRuntimeContext {
    public:
        TRuntimeContext(const NJson::TConfig& config, const TString& path);
        ~TRuntimeContext();

        void AddUnistat(NUnistat::TBuilder& builder) const;
        NJuggler::TStatus GetStatus() const;

        ui32 CheckServiceTicket(TStringBuf ticket, TStringBuf expectedRole) const;

        bool IsForceDown() const;

        NDbPool::TDbPool& GetDb() const;
        const NGeobase::IGeobase& GetGeobase() const;

        const TFactorsSettings& GetFactorsSettings() const;
        const TTestingNumbers& GetTestingNumbers() const;

    private:
        void InitTvm(const NJson::TConfig& config, const TString& path);
        void InitDb(const NJson::TConfig& config, const TString& path);
        void InitGeobase(const NJson::TConfig& config, const TString& path);
        void InitFactorSettings(const NJson::TConfig& config, const TString& path);
        void InitMisc(const NJson::TConfig& config, const TString& path);
        void InitTestingNumbers(const NJson::TConfig& config, const TString& path);

    private:
        std::shared_ptr<NDbPool::TDbPoolCtx> DbCtx_;
        std::shared_ptr<NDbPool::TDbPool> Db_;

        std::unique_ptr<NGeobase::IGeobase> Geobase_;

        std::unique_ptr<NTvmAuth::TTvmClient> Tvm_;
        ui32 SelfTvmId_ = 0;
        TFactorsSettings FactorsSettings_;
        TTestingNumbers TestingNumbers_;

        TString ForceDownFile_;
    };
}
