#include "utils.h"

#include "exceptions.h"

#include <passport/infra/libs/cpp/utils/string/string_utils.h>

namespace NPassport::NPharmaApi {
    TString TUtils::MaskPhoneNumber(TString&& phone) {
        // replace: +7 8238435435 926 123-**-**
        ui8 digits = 0;

        for (auto it = phone.rbegin(); it != phone.rend(); ++it) {
            if (NUtils::NotDigit(*it)) {
                continue;
            }

            *it = '*';
            if (++digits == 4) {
                break;
            }
        }

        return std::move(phone);
    }

    TString TUtils::SanitizeNumber(TStringBuf rawNumber) {
        TString res;

        res.reserve(rawNumber.size());
        std::copy_if(rawNumber.begin(),
                     rawNumber.end(),
                     std::back_inserter(res),
                     [](char c) { return !NUtils::NotDigit(c); });

        if (res.empty()) {
            throw TInvalidValueError() << "Invalid number format: '" << rawNumber << "'";
        }

        return res;
    }

    time_t TUtils::InvertTs(time_t ts) {
        return std::numeric_limits<ui32>::max() - ts;
    }
}
