#include <passport/infra/daemons/pharmaapi/src/number_meta_helper.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NPharmaApi;

Y_UNIT_TEST_SUITE(NumberMetaHelper) {
    Y_UNIT_TEST(process) {
        UNIT_ASSERT_EXCEPTION_CONTAINS(TNumberMetaHelper::Process(""),
                                       yexception,
                                       "failed to parse number");

        UNIT_ASSERT_VALUES_EQUAL(
            TNumberMetaChunk({
                .CountryCode = 1,
                .E164 = "+123",
            }),
            TNumberMetaHelper::Process("123"));

        UNIT_ASSERT_VALUES_EQUAL(
            TNumberMetaChunk({
                .CountryCode = 7,
                .OperatorCode = "903",
                .E164 = "+79030000000",
                .Region = "RU",
            }),
            TNumberMetaHelper::Process("79030000000"));
    }
}

template <>
void Out<TNumberMetaChunk>(IOutputStream& o, const TNumberMetaChunk& value) {
    o << "countryCode=" << value.CountryCode << Endl;
    o << "operatorCode=" << value.OperatorCode << Endl;
    o << "e164=" << value.E164 << Endl;
    o << "region=" << value.Region << Endl;
}
