#include <passport/infra/daemons/pharmaapi/src/output/factors_by_number_result.h>
#include <passport/infra/daemons/pharmaapi/src/output/serializer.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NPharmaApi;

Y_UNIT_TEST_SUITE(Serizalizer) {
    Y_UNIT_TEST(serializeError) {
        UNIT_ASSERT_VALUES_EQUAL(
            R"({"error":"kek"})",
            TSerializer::SerializeError("kek"));
        UNIT_ASSERT_VALUES_EQUAL(
            R"({"error":"kek"})",
            TSerializer::SerializeError(std::runtime_error("kek")));
    }

    Y_UNIT_TEST(serializeFactors) {
        UNIT_ASSERT_VALUES_EQUAL(
            R"({"number_meta":null,)"
            R"("factors":{)"
            R"("bindings":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0,"maybe_more":false},)"
            R"("usages":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0,"maybe_more":false},)"
            R"("unique_uids":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0},)"
            R"("unique_ip":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0},)"
            R"("unique_as":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0},)"
            R"("unique_user_agent":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0})"
            R"(}})",
            TSerializer::Serialize(TFactorsByNumberResult{}));

        UNIT_ASSERT_VALUES_EQUAL(
            R"({"number_meta":{"country_code":17,"operator_code":"038","e164":"kek","region":"KGB"},)"
            R"("factors":{)"
            R"("bindings":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0,"maybe_more":false},)"
            R"("usages":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0,"maybe_more":false},)"
            R"("unique_uids":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0},)"
            R"("unique_ip":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0},)"
            R"("unique_as":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0},)"
            R"("unique_user_agent":{"last_hour":0,"last_day":0,"last_month":0,"last_year":0})"
            R"(}})",
            TSerializer::Serialize(TFactorsByNumberResult{
                .NumberMeta = TNumberMetaChunk{
                    .CountryCode = 17,
                    .OperatorCode = "038",
                    .E164 = "kek",
                    .Region = "KGB",
                },
            }));

        UNIT_ASSERT_VALUES_EQUAL(
            R"({"number_meta":null,)"
            R"("factors":{)"
            R"("bindings":{"last_hour":100,"last_day":200,"last_month":300,"last_year":400,"maybe_more":true},)"
            R"("usages":{"last_hour":110,"last_day":210,"last_month":310,"last_year":410,"maybe_more":false},)"
            R"("unique_uids":{"last_hour":10,"last_day":20,"last_month":30,"last_year":40},)"
            R"("unique_ip":{"last_hour":11,"last_day":21,"last_month":31,"last_year":41},)"
            R"("unique_as":{"last_hour":12,"last_day":22,"last_month":32,"last_year":42},)"
            R"("unique_user_agent":{"last_hour":13,"last_day":23,"last_month":33,"last_year":43})"
            R"(}})",
            TSerializer::Serialize(TFactorsByNumberResult{
                .Factors = {
                    .Bindings = {
                        .Counters = {
                            .LastHour = 100,
                            .LastDay = 200,
                            .LastMonth = 300,
                            .LastYear = 400,
                        },
                        .MaybeMore = true,
                    },
                    .Usages = {
                        .Counters = {
                            .LastHour = 110,
                            .LastDay = 210,
                            .LastMonth = 310,
                            .LastYear = 410,
                        },
                    },
                    .UniqUids = {
                        .LastHour = 10,
                        .LastDay = 20,
                        .LastMonth = 30,
                        .LastYear = 40,
                    },
                    .UniqIp = {
                        .LastHour = 11,
                        .LastDay = 21,
                        .LastMonth = 31,
                        .LastYear = 41,
                    },
                    .UniqAs = {
                        .LastHour = 12,
                        .LastDay = 22,
                        .LastMonth = 32,
                        .LastYear = 42,
                    },
                    .UniqUserAgent = {
                        .LastHour = 13,
                        .LastDay = 23,
                        .LastMonth = 33,
                        .LastYear = 43,
                    },
                },
            }));
    }
}
