#include <passport/infra/daemons/pharmaapi/src/utils.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NPassport;
using namespace NPassport::NPharmaApi;

Y_UNIT_TEST_SUITE(Utils) {
    Y_UNIT_TEST(maskPhoneNumber) {
        UNIT_ASSERT_VALUES_EQUAL("12345****",
                                 TUtils::MaskPhoneNumber("123456789"));
        UNIT_ASSERT_VALUES_EQUAL("+7 (903) 000-**-**",
                                 TUtils::MaskPhoneNumber("+7 (903) 000-00-00"));
    }

    Y_UNIT_TEST(sanitizeNumber) {
        UNIT_ASSERT_VALUES_EQUAL("123456789",
                                 TUtils::SanitizeNumber("123456789"));
        UNIT_ASSERT_VALUES_EQUAL("79030000000",
                                 TUtils::SanitizeNumber("+7 (903) 000-00-00"));
    }

    Y_UNIT_TEST(invertTs) {
        UNIT_ASSERT_VALUES_EQUAL(4294967295, TUtils::InvertTs(0));
        UNIT_ASSERT_VALUES_EQUAL(1604065560, TUtils::InvertTs(2690901735));
        UNIT_ASSERT_VALUES_EQUAL(456, TUtils::InvertTs(4294966839));
    }
}
