#!/bin/bash
#
#

readonly FORCE_DOWN_FILE="/var/run/passport-push-subscription.down"
readonly CRIT_DOWNTIME=600

die () {
    printf "%s;%s\n" "${1}" "${2}"
    exit 0
}

# Cleanup on exit
cleanup() {
    rm -f ${CURL_RESPONSE_FILE} 2>/dev/null
    rm -f ${CURL_STDOUT_FILE} 2>/dev/null
    rm -f ${CURL_STDERR_FILE} 2>/dev/null
}

trap cleanup EXIT

FORCE_DOWN_TIMESTAMP=$(cat ${FORCE_DOWN_FILE} 2>/dev/null)
if [[ ${FORCE_DOWN_TIMESTAMP} ]]; then
    if [[ $(date +%s) -le `expr ${FORCE_DOWN_TIMESTAMP} + ${CRIT_DOWNTIME}` ]]; then
        die "0" "Restart is in progress, skip checking"
    else
        die "2" "Service is forced-down for more than 10m"
    fi
fi

readonly CURL_RESPONSE_FILE=$(mktemp)
readonly CURL_STDOUT_FILE=$(mktemp)
readonly CURL_STDERR_FILE=$(mktemp)

curl --connect-timeout 3 --max-time 6 -k -sS -w "%{http_code}" "http://localhost:8075/healthcheck" -o ${CURL_RESPONSE_FILE} >${CURL_STDOUT_FILE} 2>${CURL_STDERR_FILE}
if [[ $? -gt 0 ]]; then
    die "2" "$(cat ${CURL_STDERR_FILE})"
fi

RESPONSE_CODE=$(cat ${CURL_STDOUT_FILE})
if [[ ${RESPONSE_CODE} -ne 200 ]]; then
    die "2" "status code error: ${RESPONSE_CODE}"
fi

cat ${CURL_RESPONSE_FILE}
