import json
import sys


SETTINGS = {
    "testing": {
        "SELF_TVM_ID": 2035359,
        "BLACKBOX_TVM_ID": 224,
        "XIVA_TVM_ID": 2002788,
        "BLACKBOX_URL": "https://blackbox-test.yandex.net",
        "XIVA_URL": "https://push-sandbox.yandex.ru",
    },
    "production": {
        "SELF_TVM_ID": 2035357,
        "BLACKBOX_TVM_ID": 222,
        "XIVA_TVM_ID": 2008797,
        "BLACKBOX_URL": "https://blackbox.yandex.net",
        "XIVA_URL": "https://push.yandex.ru",
    },
}

MAPPING = {
    "development": "testing",
    "rc": "production",
}

for k, v in MAPPING.items():
    SETTINGS[k] = SETTINGS[v]


def do(template, env):
    if env not in SETTINGS:
        raise Exception("env '%s' is unknown" % env)

    setts = SETTINGS[env]
    for key, value in setts.items():
        template = template.replace('<<%s>>' % key, str(value))

    if '<<' in template or '>>' in template:
        raise Exception("some options were not specified: %s\n" % template)

    print(template)


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print("Usage: %s <template_file> <env>" % (sys.argv[0]))
        sys.exit(1)

    with open(sys.argv[1]) as f:
        template = f.read()
        assert len(template) > 0

    do(template, sys.argv[2])
