package bb

import (
	"context"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"a.yandex-team.ru/library/go/yandex/tvm"
	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/model"
	"a.yandex-team.ru/passport/shared/golibs/unistat"
	"a.yandex-team.ru/passport/shared/golibs/unistat/unistatresty"
	"a.yandex-team.ru/passport/shared/golibs/utils"
)

type Config struct {
	URL     string         `json:"url"`
	Timeout utils.Duration `json:"timeout"`
	Retries int            `json:"retries"`
}

type Client struct {
	http    *httpbb.Client
	unistat stats
}

type stats struct {
	InvalidTokens *unistat.SignalDiff
}

func NewClient(cfg Config, tvmclient tvm.Client, tvmid tvm.ClientID) (*Client, error) {
	httpc := resty.New().
		SetBaseURL(cfg.URL).
		SetRedirectPolicy(resty.NoRedirectPolicy())

	bbClient, err := httpbb.NewClientWithResty(
		httpbb.Environment{
			BlackboxHost: cfg.URL,
			TvmID:        tvmid,
		},
		httpc,
		httpbb.WithTVM(tvmclient),
		httpbb.WithTimeout(cfg.Timeout.Duration),
		httpbb.WithRetries(cfg.Retries),
	)
	if err != nil {
		return nil, xerrors.Errorf("Failed to create blackbox client: %v", err)
	}

	unistatresty.PrepareStats(unistatresty.Config{
		Client:          httpc,
		UnistatPrefix:   "blackbox",
		MaxResponseTime: 10 * cfg.Timeout.Duration,
	})

	res := &Client{
		http: bbClient,
		unistat: stats{
			InvalidTokens: unistat.DefaultChunk.CreateSignalDiff("blackbox.invalid_tokens"),
		},
	}

	if err := res.CheckOAuthGrants(context.Background(), &model.AuthRequest{}); err != nil {
		return nil, xerrors.Errorf("failed to check grants: %v", err)
	}

	return res, nil
}
