package bb

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/errs"
	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/model"
)

func (b *Client) CheckOAuth(ctx context.Context, req *model.AuthRequest) (*model.AuthResponse, error) {
	response, err := b.http.OAuth(ctx, blackbox.OAuthRequest{
		OAuthToken: req.Token,
		UserIP:     req.UserIP,
		Scopes:     []string{"oauth:grant_xtoken"},
		GetLoginID: true,
	})
	if err != nil {
		if _, ok := err.(*blackbox.StatusError); ok {
			b.unistat.InvalidTokens.Inc()
			return nil, &errs.InvalidParamError{
				Key:     "oauth_token",
				Type:    errs.InvalidParamErrorTypeInvalid,
				Message: err.Error(),
			}
		}
		return nil, &errs.TemporaryError{Message: err.Error()}
	}

	return &model.AuthResponse{
		UID:     response.User.UID.ID,
		LoginID: response.LoginID,
	}, nil
}
