package model

import "context"

type AuthProviders interface {
	OAuthProvider
	GrantsProvider
}

type OAuthProvider interface {
	CheckOAuth(ctx context.Context, req *AuthRequest) (*AuthResponse, error)
}

type GrantsProvider interface {
	CheckOAuthGrants(ctx context.Context, req *AuthRequest) error
}

type PushProviders interface {
	PingProvider
	SubscribeProvider
	UnsubscribeProvider
}

type PingProvider interface {
	Ping(ctx context.Context) error
}

type SubscribeProvider interface {
	Subscribe(ctx context.Context, req *SubscribeRequest) (*SubscribeResponse, error)
}

type UnsubscribeProvider interface {
	Unsubscribe(ctx context.Context, req *UnsubscribeRequest) error
}
