package model

import "a.yandex-team.ru/library/go/yandex/blackbox"

type AuthRequest struct {
	Token  string
	UserIP string
}

type AuthResponse struct {
	UID     blackbox.ID
	LoginID string
}

type SubscribeRequest struct {
	AppName   string
	Client    string
	DeviceID  string
	Extra     SubscribeExtra
	Platform  string
	PushToken string
	UUID      string
	User      string
	Filter    string
}

type SubscribeExtra struct {
	AmVersion  string `json:"0,omitempty"`
	LoginID    string `json:"1,omitempty"`
	AppVersion string `json:"2,omitempty"`
}

type SubscribeResponse struct {
	SubscriptionID string `json:"subscription-id"`
}

type UnsubscribeRequest struct {
	User string
	UUID string
}
