package xiva

import (
	"context"
	"encoding/json"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/xerrors"
	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/model"
)

func (x *Client) Subscribe(ctx context.Context, req *model.SubscribeRequest) (*model.SubscribeResponse, error) {
	newReq := x.http.R().
		SetContext(ctx).
		SetQueryParams(createSubscribeQueryParams(req, x.cfg.Service)).
		SetHeader("Content-Type", "application/x-www-form-urlencoded")

	form, err := createSubscribeFormData(req)
	if err != nil {
		return nil, err
	}
	newReq.SetFormData(form)

	if err := x.addTvm(ctx, newReq); err != nil {
		return nil, err
	}

	res := &model.SubscribeResponse{}
	err = x.withRetries(newReq, "/v2/subscribe/app", func(resp *resty.Response) error {
		// now fine response is 'OK'
		// TODO: ask xiva to respond with JSON
		return nil
	})

	return res, err
}

func createSubscribeQueryParams(req *model.SubscribeRequest, service string) map[string]string {
	res := map[string]string{
		"service":  service,
		"user":     req.User,
		"uuid":     req.UUID,
		"device":   req.DeviceID,
		"platform": req.Platform,
		"app_name": req.AppName,
	}

	if req.Client != "" {
		res["client"] = req.Client
	}

	return res
}

func createSubscribeFormData(req *model.SubscribeRequest) (map[string]string, error) {
	res := map[string]string{
		"push_token": req.PushToken,
	}

	if req.Filter != "" {
		res["filter"] = req.Filter
	}

	extra, err := json.Marshal(req.Extra)
	if err != nil {
		return nil, xerrors.Errorf("failed to marshal extra field: %v", err)
	}

	res["extra"] = string(extra)

	return res, nil
}
