package xiva

import (
	"context"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/passport/infra/daemons/push_subscription/internal/model"
)

func (x *Client) Unsubscribe(ctx context.Context, req *model.UnsubscribeRequest) error {
	newReq := x.http.R().
		SetContext(ctx).
		SetQueryParams(createUnsubscribeQueryParams(req, x.cfg.Service))

	if err := x.addTvm(ctx, newReq); err != nil {
		return err
	}

	return x.withRetries(newReq, "/v2/unsubscribe/app", func(resp *resty.Response) error {
		return nil
	})
}

func createUnsubscribeQueryParams(req *model.UnsubscribeRequest, service string) map[string]string {
	return map[string]string{
		"service": service,
		"user":    req.User,
		"uuid":    req.UUID,
	}
}
